<?php
$base = '/ramblerco';

// Load data
$cats_json = file_get_contents(__DIR__ . '/data/catalogs.json');
$data      = json_decode($cats_json, true);
$all_cats  = $data['catalogs'];

// Get catalog by ID
$cat_id  = isset($_GET['id']) ? (int)$_GET['id'] : 1;
$catalog = null;
foreach ($all_cats as $c) {
  if ($c['id'] === $cat_id) { $catalog = $c; break; }
}

// 404 fallback
if (!$catalog) {
  $catalog = $all_cats[0];
}

// Related (same category, different id)
$related = array_filter($all_cats, fn($c) => $c['category'] === $catalog['category'] && $c['id'] !== $catalog['id']);

// Active subcategory filter
$active_sub = isset($_GET['sub']) ? htmlspecialchars($_GET['sub']) : 'all';
$subcats    = array_unique(array_column($catalog['products'], 'subcategory'));
$products   = $active_sub === 'all'
  ? $catalog['products']
  : array_filter($catalog['products'], fn($p) => $p['subcategory'] === $active_sub);

$page_title = $catalog['title'] . ' — Rambler Qatar';
$meta_desc  = $catalog['description'];

include __DIR__ . '/includes/header.php';
?>

<!-- ── Catalog Hero ── -->
<section class="page-hero" style="min-height:50vh;display:flex;align-items:flex-end;background:linear-gradient(135deg,<?= $catalog['gradient_from'] ?>18 0%,<?= $catalog['gradient_to'] ?>0C 60%,#F6F3EE 100%);">
  <!-- Top accent line -->
  <div class="absolute top-0 left-0 right-0 h-1"
       style="background:linear-gradient(to right,transparent,<?= $catalog['accent'] ?>99,transparent);"></div>
  <!-- Dot grid overlay -->
  <div class="absolute inset-0" style="background-image:radial-gradient(circle at 1px 1px,rgba(0,0,0,0.04) 1px,transparent 0);background-size:24px 24px;pointer-events:none;"></div>

  <div class="container-xl relative z-10 w-full pb-12">
    <!-- Breadcrumb -->
    <div class="flex items-center gap-2 text-xs mb-8" style="color:rgba(0,0,0,0.35);">
      <a href="<?= $base ?>/index.php" class="transition-colors" style="color:rgba(0,0,0,0.35);"
         onmouseover="this.style.color='rgba(0,0,0,0.65)'" onmouseout="this.style.color='rgba(0,0,0,0.35)'">Home</a>
      <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
      <a href="<?= $base ?>/catalog.php" class="transition-colors" style="color:rgba(0,0,0,0.35);"
         onmouseover="this.style.color='rgba(0,0,0,0.65)'" onmouseout="this.style.color='rgba(0,0,0,0.35)'">Catalogues</a>
      <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
      <span style="color:#3A3745;"><?= htmlspecialchars($catalog['title']) ?></span>
    </div>

    <div class="flex flex-col lg:flex-row lg:items-end lg:justify-between gap-8">
      <!-- Left info -->
      <div>
        <!-- Category badge -->
        <div class="inline-flex items-center gap-2 mb-5 px-4 py-2 rounded-full text-xs font-bold uppercase tracking-wider"
             style="background:<?= $catalog['accent'] ?>22;color:<?= $catalog['accent'] ?>;border:1px solid <?= $catalog['accent'] ?>44;">
          <span class="w-1.5 h-1.5 rounded-full" style="background:<?= $catalog['accent'] ?>;"></span>
          <?= htmlspecialchars($catalog['category']) ?>
        </div>

        <h1 class="text-4xl md:text-6xl font-display font-bold mb-4 leading-tight" style="color:#0E0B16;">
          <?= htmlspecialchars($catalog['title']) ?>
        </h1>
        <p class="text-base max-w-2xl leading-relaxed" style="color:#7A7788;">
          <?= htmlspecialchars($catalog['description']) ?>
        </p>

        <!-- Tags -->
        <div class="flex flex-wrap gap-2 mt-5">
          <?php foreach ($catalog['tags'] as $tag): ?>
          <span class="catalog-tag text-xs"
                style="color:<?= $catalog['accent'] ?>;background:<?= $catalog['accent'] ?>18;border:1px solid <?= $catalog['accent'] ?>33;">
            # <?= htmlspecialchars($tag) ?>
          </span>
          <?php endforeach; ?>
        </div>
      </div>

      <!-- Right stats card -->
      <div class="glass-card p-6 min-w-[260px] flex-shrink-0">
        <div class="grid grid-cols-2 gap-4">
          <div class="text-center p-4 rounded-xl" style="background:<?= $catalog['accent'] ?>11;">
            <div class="text-2xl font-bold font-display mb-1" style="color:<?= $catalog['accent'] ?>;">
              <?= number_format($catalog['products_count']) ?>+
            </div>
            <div class="text-xs" style="color:#7A7788;">Products</div>
          </div>
          <div class="text-center p-4 rounded-xl" style="background:#F6F3EE;">
            <div class="text-2xl font-bold font-display mb-1" style="color:#0E0B16;"><?= $catalog['year'] ?></div>
            <div class="text-xs" style="color:#7A7788;">Collection</div>
          </div>
        </div>
        <div class="mt-4 space-y-2">
          <?php foreach (['Free design proof', 'Custom MOQ available', '24h quote turnaround'] as $feat): ?>
          <div class="flex items-center gap-2 text-xs" style="color:#7A7788;">
            <svg class="w-3.5 h-3.5 flex-shrink-0" style="color:<?= $catalog['accent'] ?>;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"/>
            </svg>
            <?= $feat ?>
          </div>
          <?php endforeach; ?>
        </div>
        <a href="<?= $base ?>/index.php#contact"
           class="btn-primary w-full justify-center mt-5 px-5 py-3 rounded-xl text-sm">
          Request a Quote
        </a>
      </div>
    </div>
  </div>
</section>

<!-- ── Products Section ── -->
<section class="section-spacing pt-12" style="background:#FFFFFF;">
  <div class="container-xl">

    <!-- Section Heading -->
    <div class="mb-10 reveal">
      <div class="flex items-center gap-3 mb-2">
        <div style="width:32px;height:2px;background:linear-gradient(to right,<?= $catalog['accent'] ?>,#C9A84C);border-radius:2px;flex-shrink:0;"></div>
        <span style="font-size:10px;font-weight:700;letter-spacing:.14em;text-transform:uppercase;color:#ADAAB8;">Product Range</span>
      </div>
      <h2 class="text-2xl md:text-3xl font-display font-bold" style="color:#0E0B16;">
        <?= number_format($catalog['products_count']) ?>+ <span class="gradient-text">Products</span> in this Catalogue
      </h2>
    </div>

    <!-- Filter Tabs -->
    <div class="flex flex-wrap items-center gap-3 mb-10 reveal">
      <a href="?id=<?= $catalog['id'] ?>"
         class="filter-tab <?= $active_sub === 'all' ? 'active' : '' ?>">
        All Products
        <span class="ml-1" style="color:rgba(0,0,0,0.3);">(<?= count($catalog['products']) ?>)</span>
      </a>
      <?php foreach ($subcats as $sub):
        $cnt = count(array_filter($catalog['products'], fn($p) => $p['subcategory'] === $sub));
      ?>
      <a href="?id=<?= $catalog['id'] ?>&sub=<?= urlencode($sub) ?>"
         class="filter-tab <?= $active_sub === $sub ? 'active' : '' ?>">
        <?= htmlspecialchars($sub) ?>
        <span class="ml-1" style="color:rgba(0,0,0,0.3);">(<?= $cnt ?>)</span>
      </a>
      <?php endforeach; ?>
    </div>

    <!-- Products Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-5 mb-16">
      <?php foreach ($products as $i => $product): ?>
      <div class="product-card reveal" style="transition-delay: <?= ($i % 4) * 0.07 ?>s">
        <!-- Thumbnail -->
        <div class="product-thumbnail"
             style="background: linear-gradient(135deg, <?= $catalog['gradient_from'] ?>33, <?= $catalog['gradient_to'] ?>22);">
          <!-- Decorative pattern -->
          <div class="absolute inset-0 opacity-10"
               style="background-image: radial-gradient(circle at 1px 1px, <?= $catalog['accent'] ?>88 1px, transparent 0); background-size: 20px 20px;">
          </div>
          <!-- Product letter icon -->
          <div class="relative z-10 text-center">
            <div class="text-4xl font-bold font-display mb-1"
                 style="color:<?= $catalog['accent'] ?>;opacity:0.8;">
              <?= strtoupper(substr($product['name'], 0, 1)) ?>
            </div>
            <div class="text-xs font-mono" style="color:rgba(255,255,255,0.5);"><?= $product['sku'] ?></div>
          </div>

          <!-- Featured badge -->
          <?php if ($product['featured']): ?>
          <span class="product-badge">Featured</span>
          <?php endif; ?>
        </div>

        <!-- Product Info -->
        <div class="p-5">
          <!-- Subcategory -->
          <span class="text-[10px] font-semibold uppercase tracking-wider" style="color:rgba(0,0,0,0.35);">
            <?= htmlspecialchars($product['subcategory']) ?>
          </span>

          <!-- Name -->
          <h3 class="font-semibold text-sm mt-1 mb-2 leading-snug" style="color:#0E0B16;">
            <?= htmlspecialchars($product['name']) ?>
          </h3>

          <!-- Description -->
          <p class="text-xs leading-relaxed mb-4 line-clamp-2" style="color:#7A7788;">
            <?= htmlspecialchars($product['description']) ?>
          </p>

          <!-- Price + MOQ -->
          <div class="flex items-center justify-between mb-4">
            <div>
              <span class="text-[10px] block mb-0.5" style="color:rgba(0,0,0,0.35);">From</span>
              <span class="text-base font-bold" style="color:<?= $catalog['accent'] ?>;">
                QAR <?= number_format($product['price_from']) ?>
              </span>
            </div>
            <span class="moq-badge">
              <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
              </svg>
              MOQ: <?= $product['moq'] ?>
            </span>
          </div>

          <!-- CTA -->
          <a href="<?= $base ?>/index.php#contact"
             class="btn-ghost w-full justify-center py-2.5 rounded-xl text-xs">
            Request Quote
          </a>
        </div>
      </div>
      <?php endforeach; ?>
    </div>

    <!-- No Results -->
    <?php if (empty($products)): ?>
    <div class="text-center py-20 reveal">
      <div class="text-5xl mb-4">📦</div>
      <h3 class="font-semibold text-lg mb-2" style="color:#0E0B16;">No products in this subcategory</h3>
      <a href="?id=<?= $catalog['id'] ?>" class="btn-ghost px-5 py-2.5 rounded-full text-sm mt-4 inline-flex">View All Products</a>
    </div>
    <?php endif; ?>

    <!-- Luxury Divider -->
    <div class="mb-16 text-center">
      <div class="luxury-divider"></div>
      <div class="mt-5 flex items-center justify-center gap-4">
        <div style="height:1px;width:48px;background:linear-gradient(to right,transparent,rgba(0,0,0,0.08));"></div>
        <span style="font-size:9px;letter-spacing:.22em;text-transform:uppercase;color:#ADAAB8;">Custom Branding Available</span>
        <div style="height:1px;width:48px;background:linear-gradient(to left,transparent,rgba(0,0,0,0.08));"></div>
      </div>
    </div>

    <!-- Quote CTA Banner -->
    <div class="glass-card luxury-quote-banner p-8 md:p-12 reveal"
         style="background:linear-gradient(135deg,<?= $catalog['gradient_from'] ?>0E,<?= $catalog['gradient_to'] ?>08,#FFFFFF);border-color:<?= $catalog['accent'] ?>22;">
      <div class="flex flex-col md:flex-row items-center md:items-start gap-8">
        <div class="flex-1">
          <h3 class="text-2xl md:text-3xl font-bold font-display mb-3" style="color:#0E0B16;">
            Need These Products Branded?
          </h3>
          <p class="text-sm leading-relaxed max-w-lg" style="color:#7A7788;">
            Share your logo and requirements — we'll prepare a detailed quote with product samples within 24 hours. Minimum order quantities are flexible.
          </p>
          <div class="flex flex-wrap gap-6 mt-6">
            <?php foreach (['Laser Engraving', 'Screen Printing', 'Embroidery', 'Full-Color Print'] as $method): ?>
            <div class="flex items-center gap-2 text-xs" style="color:#7A7788;">
              <span class="w-1.5 h-1.5 rounded-full" style="background:<?= $catalog['accent'] ?>;"></span>
              <?= $method ?>
            </div>
            <?php endforeach; ?>
          </div>
        </div>
        <div class="flex flex-col gap-3 flex-shrink-0 w-full md:w-auto">
          <a href="<?= $base ?>/index.php#contact"
             class="btn-primary px-8 py-4 rounded-xl text-sm justify-center">
            Get a Custom Quote
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
            </svg>
          </a>
          <a href="tel:+97470993232"
             class="btn-ghost px-8 py-4 rounded-xl text-sm justify-center">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
            </svg>
            +974 7099 3232
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ── Related Catalogues ── -->
<?php if (!empty($related)): ?>
<section class="section-spacing" style="background:#EDEAE3;border-top:1px solid rgba(0,0,0,0.06);">
  <div class="container-xl">
    <div class="mb-10 reveal">
      <div class="flex items-center gap-3 mb-3">
        <div style="width:32px;height:2px;background:linear-gradient(to right,<?= $catalog['accent'] ?>,#C9A84C);border-radius:2px;flex-shrink:0;"></div>
        <span style="font-size:10px;font-weight:700;letter-spacing:.14em;text-transform:uppercase;color:#ADAAB8;">More Catalogues</span>
      </div>
      <div class="flex items-center justify-between">
        <h2 class="text-2xl md:text-3xl font-display font-bold" style="color:#0E0B16;">
          Related <span class="gradient-text">Catalogues</span>
        </h2>
        <a href="<?= $base ?>/catalog.php" class="btn-ghost px-5 py-2.5 rounded-full text-xs">
          View All
        </a>
      </div>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-5 stagger-children">
      <?php foreach (array_slice($related, 0, 3) as $rel): ?>
      <a href="<?= $base ?>/catalog-detail.php?id=<?= $rel['id'] ?>" class="catalog-card group block">
        <div class="catalog-cover"
             style="background:linear-gradient(135deg,<?= $rel['gradient_from'] ?>,<?= $rel['gradient_to'] ?>);height:160px;">
          <div class="catalog-cover-pattern"></div>
          <span style="font-size:5rem;color:rgba(255,255,255,0.08);font-weight:900;font-family:'Plus Jakarta Sans',sans-serif;line-height:1;">
            <?= str_pad($rel['id'], 2, '0', STR_PAD_LEFT) ?>
          </span>
          <div class="book-shine-overlay"></div>
        </div>
        <div class="p-5">
          <h3 class="font-semibold text-sm mb-1 transition-colors" style="color:#0E0B16;"
              onmouseover="this.style.color='#C42830'" onmouseout="this.style.color='#0E0B16'">
            <?= htmlspecialchars($rel['title']) ?>
          </h3>
          <p class="text-xs" style="color:#7A7788;"><?= number_format($rel['products_count']) ?>+ products</p>
        </div>
      </a>
      <?php endforeach; ?>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- ── All Catalogs Nav ── -->
<div class="py-6" style="background:#FFFFFF;border-top:1px solid rgba(0,0,0,0.07);">
  <div class="container-xl">
    <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
      <a href="<?= $base ?>/catalog.php" class="flex items-center gap-2 text-sm transition-colors"
         style="color:#7A7788;"
         onmouseover="this.style.color='#0E0B16'" onmouseout="this.style.color='#7A7788'">
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12"/>
        </svg>
        All Catalogues
      </a>
      <div class="flex items-center gap-2">
        <?php foreach ($all_cats as $c): ?>
        <a href="?id=<?= $c['id'] ?>"
           class="w-8 h-8 rounded-full text-xs font-bold flex items-center justify-center transition-all duration-200"
           title="<?= htmlspecialchars($c['title']) ?>"
           style="<?= $c['id'] === $catalog['id']
             ? 'background:' . $catalog['accent'] . '; color:#FFFFFF;'
             : 'background:rgba(0,0,0,0.06);color:#7A7788;' ?>">
          <?= str_pad($c['id'], 2, '0', STR_PAD_LEFT) ?>
        </a>
        <?php endforeach; ?>
      </div>
      <?php
      $next = null;
      foreach ($all_cats as $c) { if ($c['id'] === $catalog['id'] + 1) { $next = $c; break; } }
      if ($next): ?>
      <a href="?id=<?= $next['id'] ?>" class="flex items-center gap-2 text-sm transition-colors"
         style="color:#7A7788;"
         onmouseover="this.style.color='#0E0B16'" onmouseout="this.style.color='#7A7788'">
        <?= htmlspecialchars($next['title']) ?>
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
        </svg>
      </a>
      <?php else: ?>
      <a href="<?= $base ?>/catalog.php" class="flex items-center gap-2 text-sm transition-colors"
         style="color:#7A7788;"
         onmouseover="this.style.color='#0E0B16'" onmouseout="this.style.color='#7A7788'">
        Back to All
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
        </svg>
      </a>
      <?php endif; ?>
    </div>
  </div>
</div>

<!-- ── Catalog Detail Page JS ── -->
<script>
document.addEventListener('DOMContentLoaded', () => {
  if (typeof gsap === 'undefined' || typeof ScrollTrigger === 'undefined') return;
  gsap.registerPlugin(ScrollTrigger);

  // ── Product cards — luxury stagger ──
  gsap.utils.toArray('.product-card').forEach((card, i) => {
    gsap.fromTo(card,
      { opacity: 0, y: 45, scale: .95 },
      { opacity: 1, y: 0, scale: 1,
        duration: .78, delay: (i % 4) * .08,
        ease: 'back.out(1.3)',
        scrollTrigger: { trigger: card, start: 'top 92%' }
      }
    );
  });

  // ── Related catalog cards ──
  gsap.utils.toArray('.catalog-card').forEach((card, i) => {
    gsap.fromTo(card,
      { opacity: 0, y: 35, scale: .96 },
      { opacity: 1, y: 0, scale: 1,
        duration: .82, delay: i * .11,
        ease: 'back.out(1.4)',
        scrollTrigger: { trigger: card, start: 'top 88%' }
      }
    );
  });

  // ── Hero stats card bounce in ──
  const statsCard = document.querySelector('.page-hero .glass-card');
  if (statsCard) {
    gsap.from(statsCard, { scale: .88, opacity: 0, duration: 1.0, ease: 'back.out(1.6)', delay: .3 });
  }

  // ── Quote CTA banner reveal ──
  const ctaBanner = document.querySelector('.section-spacing .glass-card');
  if (ctaBanner) {
    gsap.from(ctaBanner, {
      y: 40, opacity: 0, duration: .95, ease: 'power3.out',
      scrollTrigger: { trigger: ctaBanner, start: 'top 85%' }
    });
  }
});
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
