<?php $base = '/ramblerco'; ?>
<!-- ── Footer ── -->
<footer class="pt-20 pb-10" style="background:linear-gradient(160deg,#131F52 0%,#0D1538 40%,#0A0D28 100%);border-top:3px solid #C42830;">
  <div class="container-xl">

    <!-- Top Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 pb-16 border-b border-white/[0.07]">

      <!-- Brand Column -->
      <div class="lg:col-span-1">
        <a href="<?= $base ?>/index.php">
          <img src="<?= $base ?>/logo (2).png" alt="Rambler Qatar" class="h-10 mb-6">
        </a>
        <p class="text-sm text-white/50 leading-relaxed mb-6">
          Qatar's premier destination for corporate gifts, promotional products, and branded merchandise.
          Trusted by 2,500+ global clients.
        </p>
        <!-- Social Links -->
        <div class="flex gap-3">
          <a href="#" class="social-link" title="LinkedIn">
            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
            </svg>
          </a>
          <a href="#" class="social-link" title="Facebook">
            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
            </svg>
          </a>
          <a href="#" class="social-link" title="Instagram">
            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
            </svg>
          </a>
          <a href="#" class="social-link" title="Twitter / X">
            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-4.714-6.231-5.401 6.231H2.74l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>
            </svg>
          </a>
        </div>
      </div>

      <!-- Pages -->
      <div>
        <h4 class="text-white font-semibold text-sm mb-5 tracking-wider uppercase">Pages</h4>
        <ul class="space-y-3">
          <li><a href="<?= $base ?>/index.php" class="footer-link hover:text-[#E03540]">Home</a></li>
          <li><a href="<?= $base ?>/catalog.php" class="footer-link hover:text-[#E03540]">Catalogues</a></li>
          <li><a href="<?= $base ?>/index.php#products" class="footer-link hover:text-[#E03540]">Products</a></li>
          <li><a href="<?= $base ?>/index.php#about" class="footer-link hover:text-[#E03540]">About Us</a></li>
          <li><a href="<?= $base ?>/index.php#contact" class="footer-link hover:text-[#E03540]">Contact</a></li>
        </ul>
      </div>

      <!-- Categories -->
      <div>
        <h4 class="text-white font-semibold text-sm mb-5 tracking-wider uppercase">Categories</h4>
        <ul class="space-y-3">
          <li><a href="<?= $base ?>/catalog.php?cat=Corporate+Gifts" class="footer-link hover:text-[#E03540]">Corporate Gifts</a></li>
          <li><a href="<?= $base ?>/catalog.php?cat=Clothing" class="footer-link hover:text-[#E03540]">Clothing & Apparel</a></li>
          <li><a href="<?= $base ?>/catalog.php?cat=Electronics" class="footer-link hover:text-[#E03540]">Electronics & Tech</a></li>
          <li><a href="<?= $base ?>/catalog.php?cat=Eco" class="footer-link hover:text-[#E03540]">Eco & Sustainable</a></li>
          <li><a href="<?= $base ?>/catalog.php?cat=Luxury" class="footer-link hover:text-[#E03540]">Luxury Collection</a></li>
        </ul>
      </div>

      <!-- Contact Info -->
      <div>
        <h4 class="text-white font-semibold text-sm mb-5 tracking-wider uppercase">Get In Touch</h4>
        <ul class="space-y-4">
          <li class="flex items-start gap-3">
            <div class="w-8 h-8 rounded-lg bg-[rgba(224,53,64,0.1)] flex items-center justify-center flex-shrink-0 mt-0.5">
              <svg class="w-3.5 h-3.5 text-[#E03540]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
              </svg>
            </div>
            <div>
              <span class="block text-xs text-white/40 mb-0.5">Phone</span>
              <a href="tel:+97470993232" class="text-sm text-white/70 hover:text-[#E03540] transition-colors">+974 7099 3232</a>
            </div>
          </li>
          <li class="flex items-start gap-3">
            <div class="w-8 h-8 rounded-lg bg-[rgba(224,53,64,0.1)] flex items-center justify-center flex-shrink-0 mt-0.5">
              <svg class="w-3.5 h-3.5 text-[#E03540]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
              </svg>
            </div>
            <div>
              <span class="block text-xs text-white/40 mb-0.5">Email</span>
              <a href="mailto:sales@ramblerco.com" class="text-sm text-white/70 hover:text-[#E03540] transition-colors">sales@ramblerco.com</a>
            </div>
          </li>
          <li class="flex items-start gap-3">
            <div class="w-8 h-8 rounded-lg bg-[rgba(224,53,64,0.1)] flex items-center justify-center flex-shrink-0 mt-0.5">
              <svg class="w-3.5 h-3.5 text-[#E03540]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
              </svg>
            </div>
            <div>
              <span class="block text-xs text-white/40 mb-0.5">Address</span>
              <span class="text-sm text-white/70">P.O. BOX 8898, Doha, Qatar</span>
            </div>
          </li>
        </ul>
      </div>
    </div>

    <!-- Bottom Bar -->
    <div class="flex flex-col md:flex-row items-center justify-between gap-4 pt-8">
      <p class="text-sm text-white/30">
        &copy; <?= date('Y') ?> Rambler Qatar Co. WLL. All rights reserved.
      </p>
      <div class="flex items-center gap-6">
        <a href="#" class="text-xs text-white/30 hover:text-white/60 transition-colors">Privacy Policy</a>
        <a href="#" class="text-xs text-white/30 hover:text-white/60 transition-colors">Terms & Conditions</a>
        <a href="#" class="text-xs text-white/30 hover:text-white/60 transition-colors">FAQ</a>
      </div>
    </div>
  </div>
</footer>

<!-- Back to Top -->
<button id="back-top"
  onclick="window.scrollTo({top:0,behavior:'smooth'})"
  class="fixed bottom-8 right-8 w-11 h-11 rounded-full btn-primary items-center justify-center z-50 opacity-0 pointer-events-none transition-all duration-300"
  aria-label="Back to top">
  <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 15l7-7 7 7"/>
  </svg>
</button>

<!-- Main JS -->
<script src="<?= $base ?>/assets/js/main.js"></script>
<script>
  // Back to top visibility
  window.addEventListener('scroll', () => {
    const btn = document.getElementById('back-top');
    if (btn) {
      if (window.scrollY > 500) {
        btn.style.opacity = '1';
        btn.style.pointerEvents = 'auto';
      } else {
        btn.style.opacity = '0';
        btn.style.pointerEvents = 'none';
      }
    }
  }, { passive: true });
</script>
</body>
</html>
