<?php
$page_title = 'Rambler Qatar — Premium Corporate Gifts & Branded Merchandise';
$meta_desc  = 'Qatar\'s premier corporate gifts and promotional products company. 6000+ products, 2500+ global clients, 10+ years experience. Get a custom quote today.';
$base       = '/ramblerco';

$cats_json = file_get_contents(__DIR__ . '/data/catalogs.json');
$data      = json_decode($cats_json, true);
$catalogs  = $data['catalogs'];
$featured  = array_values(array_filter($catalogs, fn($c) => $c['featured']));

include __DIR__ . '/includes/header.php';
?>

<!-- ═══════════════════════════════════════════
     HERO — Premium Light Luxury
════════════════════════════════════════════ -->
<section class="hero-section" style="background:linear-gradient(145deg,#F7F4EF 0%,#F0ECE5 50%,#F7F4EF 100%);">

  <!-- Subtle brand-color blobs -->
  <div class="hero-aurora" aria-hidden="true">
    <div class="aurora-orb aurora-orb-1"></div>
    <div class="aurora-orb aurora-orb-2"></div>
    <div class="aurora-orb aurora-orb-3"></div>
    <div class="aurora-orb aurora-orb-4"></div>
    <div class="aurora-orb aurora-orb-5"></div>
  </div>

  <!-- Decorative rings (top-right, behind book) -->
  <div class="hero-ring hero-ring-1" aria-hidden="true"></div>
  <div class="hero-ring hero-ring-2" aria-hidden="true"></div>
  <div class="hero-ring hero-ring-3" aria-hidden="true"></div>

  <!-- Dot grid -->
  <div class="hero-grid" aria-hidden="true"></div>
  <div class="noise-overlay" aria-hidden="true"></div>
  <div class="hero-fade-bottom" aria-hidden="true"></div>

  <!-- ── 2-Column Content ── -->
  <div class="hero-content container-xl w-full" style="padding-top:100px;padding-bottom:60px;">
    <div class="grid grid-cols-1 lg:grid-cols-[1fr_460px] gap-12 xl:gap-16 items-center min-h-[calc(100vh-160px)]">

      <!-- LEFT: Copy -->
      <div class="py-10 lg:py-20">

        <!-- Eyebrow badge -->
        <div class="hero-badge section-badge mb-8 inline-flex">
          <span class="dot"></span>
          Qatar's Premier Corporate Gifts Partner — Est. 2014
        </div>

        <!-- Headline -->
        <h1 class="hero-title mb-6" style="color:#0E0B16;">
          Elevate<br>
          <span class="gradient-text">Your Brand</span><br>
          <span style="font-size:clamp(1.4rem,2.8vw,2.6rem);font-weight:300;color:#7A7788;letter-spacing:-.01em;-webkit-text-fill-color:#7A7788;">
            with Premium Gifting
          </span>
        </h1>

        <!-- Sub-text -->
        <p style="font-size:1.05rem;line-height:1.75;color:#5A5766;max-width:500px;" class="mb-10">
          From executive pen sets to curated luxury collections — we craft unforgettable branded experiences
          for Qatar's most ambitious organisations.
        </p>

        <!-- CTAs -->
        <div class="hero-actions flex flex-wrap gap-4 mb-12">
          <a href="<?= $base ?>/catalog.php" class="btn-primary px-7 py-3.5 rounded-full text-sm font-semibold">
            Browse Catalogues
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
            </svg>
          </a>
          <a href="#contact" class="btn-ghost px-7 py-3.5 rounded-full text-sm font-semibold">
            Get a Free Quote
          </a>
        </div>

        <!-- Stat chips -->
        <div class="hero-chips flex flex-wrap gap-3">
          <span class="hero-chip"><span class="chip-dot" style="background:#C42830;"></span>6,000+ Products</span>
          <span class="hero-chip"><span class="chip-dot" style="background:#1C2E70;"></span>2,500+ Clients</span>
          <span class="hero-chip"><span class="chip-dot" style="background:#C42830;"></span>10+ Years Qatar</span>
          <span class="hero-chip"><span class="chip-dot" style="background:#1C2E70;"></span>24h Quotes</span>
        </div>
      </div>

      <!-- RIGHT: Catalog Book Visual -->
      <div class="hidden lg:block relative" style="padding:40px 0;" aria-hidden="true">

        <!-- Glow under book -->
        <div style="position:absolute;width:380px;height:280px;bottom:0;left:50%;transform:translateX(-50%);background:radial-gradient(ellipse,rgba(196,40,48,.1),transparent 70%);filter:blur(40px);pointer-events:none;z-index:0;"></div>

        <!-- The 3D Book — with float animation + gloss shine -->
        <?php $hc = $featured[0] ?? $catalogs[0]; ?>
        <div class="relative" style="z-index:2;display:flex;justify-content:center;">
          <div style="width:210px;transform:perspective(1000px) rotateY(-10deg) rotateX(2deg);">
            <!-- Float wrapper — translateY only, no conflict with perspective -->
            <div class="hero-book-float">
              <div class="pdf-book" style="box-shadow:28px 48px 80px rgba(0,0,0,.22),8px 16px 32px rgba(0,0,0,.12);">
                <div class="pdf-book-cover">
                  <div class="pdf-cover-inner" style="background:linear-gradient(135deg,<?= $hc['gradient_from'] ?>,<?= $hc['gradient_to'] ?>);position:relative;overflow:hidden;">
                    <div class="pdf-cover-pattern"></div>
                    <div class="pdf-cover-diagonal"></div>
                    <div class="pdf-cover-content">
                      <div>
                        <div style="display:flex;align-items:center;gap:5px;margin-bottom:10px;">
                          <div style="width:18px;height:2px;background:<?= $hc['accent'] ?>;border-radius:2px;"></div>
                          <span style="font-size:8px;font-weight:700;color:<?= $hc['accent'] ?>;letter-spacing:.1em;text-transform:uppercase;"><?= $hc['category'] ?></span>
                        </div>
                        <div style="font-size:7px;color:rgba(255,255,255,.35);letter-spacing:.1em;text-transform:uppercase;">Rambler Qatar</div>
                      </div>
                      <div style="font-size:68px;font-weight:900;line-height:1;color:rgba(255,255,255,.06);font-family:'Plus Jakarta Sans',sans-serif;text-align:right;"><?= str_pad($hc['id'],2,'0',STR_PAD_LEFT) ?></div>
                      <div>
                        <div style="font-size:12px;font-weight:800;color:#fff;line-height:1.25;margin-bottom:6px;font-family:'Plus Jakarta Sans',sans-serif;"><?= htmlspecialchars($hc['title']) ?></div>
                        <div style="display:flex;align-items:center;justify-content:space-between;">
                          <span style="font-size:8px;color:rgba(255,255,255,.35);"><?= $hc['pages'] ?> pages</span>
                          <span style="font-size:8px;font-weight:700;padding:2px 7px;border-radius:100px;background:<?= $hc['accent'] ?>33;color:<?= $hc['accent'] ?>;"><?= $hc['year'] ?></span>
                        </div>
                      </div>
                    </div>
                    <!-- Gloss shine sweep overlay -->
                    <div class="book-shine-overlay"></div>
                  </div>
                </div>
                <div class="pdf-book-spine"></div>
                <div class="pdf-book-pages"></div>
              </div>
            </div>
          </div>
        </div>

        <!-- Floating stat cards (white with shadow) -->
        <div class="hero-float-card" style="top:10px;right:-20px;">
          <div style="font-size:22px;font-weight:900;color:#C42830;font-family:'Plus Jakarta Sans',sans-serif;line-height:1;">6,000+</div>
          <div style="font-size:11px;color:#7A7788;margin-top:3px;font-weight:500;">Products Available</div>
        </div>

        <div class="hero-float-card" style="bottom:60px;left:-30px;">
          <div style="font-size:22px;font-weight:900;color:#1C2E70;font-family:'Plus Jakarta Sans',sans-serif;line-height:1;">2,500+</div>
          <div style="font-size:11px;color:#7A7788;margin-top:3px;font-weight:500;">Happy Clients</div>
        </div>

        <!-- Live badge -->
        <div style="position:absolute;bottom:20px;right:20px;display:inline-flex;align-items:center;gap:7px;background:#FFFFFF;border:1px solid rgba(0,0,0,0.08);border-radius:100px;padding:7px 14px;box-shadow:0 4px 16px rgba(0,0,0,.08);">
          <span style="width:7px;height:7px;border-radius:50%;background:#10B981;box-shadow:0 0 0 3px rgba(16,185,129,.2);flex-shrink:0;"></span>
          <span style="font-size:11px;color:#3A3745;font-weight:600;">2026 Edition Live</span>
        </div>

        <!-- Second catalog book (smaller, tilted behind) -->
        <?php $hc2 = $featured[1] ?? $catalogs[1]; ?>
        <div style="position:absolute;top:30px;left:-10px;width:100px;transform:perspective(600px) rotateY(8deg) rotateX(2deg) rotate(-5deg);opacity:.75;z-index:1;">
          <div class="pdf-book" style="box-shadow:10px 20px 40px rgba(0,0,0,.18);">
            <div class="pdf-book-cover">
              <div class="pdf-cover-inner" style="background:linear-gradient(135deg,<?= $hc2['gradient_from'] ?>,<?= $hc2['gradient_to'] ?>);">
                <div class="pdf-cover-pattern"></div>
                <div class="pdf-cover-content">
                  <div style="font-size:7px;color:rgba(255,255,255,.4);">Rambler Qatar</div>
                  <div style="font-size:40px;font-weight:900;color:rgba(255,255,255,.06);font-family:'Plus Jakarta Sans',sans-serif;text-align:right;"><?= str_pad($hc2['id'],2,'0',STR_PAD_LEFT) ?></div>
                  <div style="font-size:8px;font-weight:800;color:#fff;line-height:1.2;"><?= htmlspecialchars($hc2['title']) ?></div>
                </div>
              </div>
            </div>
            <div class="pdf-book-spine"></div>
            <div class="pdf-book-pages"></div>
          </div>
        </div>

      </div>
    </div>
  </div>

  <!-- Scroll indicator -->
  <div class="scroll-indicator">
    <span style="font-size:10px;letter-spacing:.15em;color:#ADAAB8;text-transform:uppercase;font-weight:500;">Scroll</span>
    <div class="scroll-line"></div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     BRAND STRIP — Trusted by
════════════════════════════════════════════ -->
<div style="border-top:1px solid rgba(0,0,0,.06);border-bottom:1px solid rgba(0,0,0,.06);background:#FFFFFF;padding:18px 0;">
  <div class="container-xl">
    <div class="flex flex-wrap items-center justify-between gap-6">
      <p style="font-size:11px;font-weight:600;letter-spacing:.12em;text-transform:uppercase;color:#ADAAB8;white-space:nowrap;">Trusted By</p>
      <div class="flex flex-wrap gap-x-8 gap-y-2 items-center">
        <?php foreach (['Qatar Airways','QNB Group','Ooredoo','Hamad Medical','Qatar Foundation','RasGas'] as $c): ?>
        <span style="font-size:12px;font-weight:700;letter-spacing:.06em;text-transform:uppercase;color:#BBBAC6;"><?= $c ?></span>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>

<!-- ═══════════════════════════════════════════
     STATS SECTION
════════════════════════════════════════════ -->
<section style="padding:80px 0;background:#FFFFFF;border-bottom:1px solid rgba(0,0,0,.06);">
  <div class="container-xl">
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-0 divide-x divide-y lg:divide-y-0" style="border:1px solid rgba(0,0,0,.07);border-radius:20px;overflow:hidden;box-shadow:0 4px 24px rgba(0,0,0,.05);">
      <?php
      $stats = [
        ['value'=>6000,'suffix'=>'+','label'=>'Unique Products',  'desc'=>'Across all categories', 'icon'=>'M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4'],
        ['value'=>2500,'suffix'=>'+','label'=>'Global Clients',   'desc'=>'In 3 continents',       'icon'=>'M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z'],
        ['value'=>10,  'suffix'=>'+','label'=>'Years Experience', 'desc'=>'In the Middle East',    'icon'=>'M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z'],
        ['value'=>70,  'suffix'=>'+','label'=>'Team Experience',  'desc'=>'Combined years',        'icon'=>'M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z'],
      ];
      foreach ($stats as $s): ?>
      <div class="text-center px-8 py-10 reveal group hover:bg-[#F7F4EF] transition-colors duration-300">
        <div style="width:44px;height:44px;border-radius:12px;background:rgba(196,40,48,.08);display:flex;align-items:center;justify-content:center;margin:0 auto 16px;">
          <svg class="w-5 h-5" style="color:#C42830;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="<?= $s['icon'] ?>"/>
          </svg>
        </div>
        <div class="stat-number gradient-text mb-1">
          <span data-counter="<?= $s['value'] ?>">0</span><?= $s['suffix'] ?>
        </div>
        <div style="font-size:.875rem;font-weight:700;color:#0E0B16;margin-bottom:3px;"><?= $s['label'] ?></div>
        <div style="font-size:.75rem;color:#ADAAB8;"><?= $s['desc'] ?></div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     BRAND PARTNERS — World-Class Luxury Brands
════════════════════════════════════════════ -->
<section class="section-spacing" style="background:#FFFFFF;">
  <div class="container-xl">

    <div class="text-center mb-14 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>Our Brand Partners</div>
      <div class="section-gold-line"></div>
      <h2 class="text-4xl md:text-5xl font-display font-bold mb-5" style="color:#0E0B16;">
        Officially Distributing <span class="gradient-text">World-Class Brands</span>
      </h2>
      <p style="color:#7A7788;" class="max-w-2xl mx-auto text-base leading-relaxed">
        As Qatar's authorised distributor, we bring the most prestigious European corporate gift brands
        — from Hugo Boss to Cerruti 1881 — directly to your organisation.
      </p>
      <div class="luxury-divider mt-8"></div>
    </div>

    <div class="grid grid-cols-2 sm:grid-cols-4 gap-5 brand-partner-grid">
      <?php
      $brands = [
        ['name'=>'Hugo Boss',         'cat'=>'Notebooks & Writing',        'init'=>'HB', 'col'=>'#2B2B2B'],
        ['name'=>'Cacharel',          'cat'=>'Fashion Accessories',         'init'=>'CA', 'col'=>'#A86070'],
        ['name'=>'Cerruti 1881',      'cat'=>'Luxury Collections',          'init'=>'C',  'col'=>'#1A3760'],
        ['name'=>'Christian Lacroix', 'cat'=>'Designer Gifts',              'init'=>'CL', 'col'=>'#6B3FA0'],
        ['name'=>'Festina',           'cat'=>'Timepieces & Watches',        'init'=>'FE', 'col'=>'#2A5FA5'],
        ['name'=>'LEXON',             'cat'=>'Nordic Design Objects',       'init'=>'LX', 'col'=>'#D95E10'],
        ['name'=>'Pinetti',           'cat'=>'Italian Leather Goods',       'init'=>'PI', 'col'=>'#8B6010'],
        ['name'=>'Prodir',            'cat'=>'Swiss Writing Instruments',   'init'=>'PR', 'col'=>'#3A4254'],
      ];
      foreach ($brands as $b): ?>
      <div class="brand-partner-card reveal"
           style="--brand-col:<?= $b['col'] ?>;--brand-col-dim:<?= $b['col'] ?>0D;">
        <!-- Icon Monogram -->
        <div class="brand-partner-icon"
             style="background:<?= $b['col'] ?>12;border-color:<?= $b['col'] ?>22;">
          <span style="font-size:17px;font-weight:900;color:<?= $b['col'] ?>;font-family:'Plus Jakarta Sans',sans-serif;letter-spacing:-.02em;line-height:1;">
            <?= $b['init'] ?>
          </span>
        </div>
        <div class="brand-partner-name"><?= $b['name'] ?></div>
        <div class="brand-partner-cat"><?= $b['cat'] ?></div>
      </div>
      <?php endforeach; ?>
    </div>

    <!-- Authorised distributor trust line -->
    <div class="flex items-center justify-center gap-3 mt-12">
      <div style="height:1px;width:60px;background:linear-gradient(to right,transparent,rgba(0,0,0,0.12));"></div>
      <p style="font-size:11px;color:#ADAAB8;letter-spacing:.12em;text-transform:uppercase;font-weight:600;white-space:nowrap;">
        Qatar's Exclusive Authorised Distributor · Est. 2014
      </p>
      <div style="height:1px;width:60px;background:linear-gradient(to left,transparent,rgba(0,0,0,0.12));"></div>
    </div>

  </div>
</section>

<!-- ═══════════════════════════════════════════
     SERVICES SECTION
════════════════════════════════════════════ -->
<section id="products" class="section-spacing" style="background:#F6F3EE;">
  <div class="container-xl">
    <div class="text-center mb-16 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>What We Offer</div>
      <h2 class="text-4xl md:text-5xl font-display font-bold mb-4" style="color:#0E0B16;">
        Everything Your Brand Needs,<br>
        <span class="gradient-text">Under One Roof</span>
      </h2>
      <p style="color:#7A7788;" class="max-w-xl mx-auto text-base leading-relaxed">
        From concept to delivery, we handle every aspect of your branded merchandise with precision and care.
      </p>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-5 stagger-children">
      <?php
      $services = [
        ['icon'=>'M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z', 'title'=>'Corporate Gifts', 'desc'=>'Curated executive gifts and luxury hampers that leave a lasting impression on every recipient.'],
        ['icon'=>'M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z', 'title'=>'Custom Branding', 'desc'=>'Laser engraving, embroidery, screen printing, and full-color UV printing on any surface.'],
        ['icon'=>'M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z', 'title'=>'Tech & Electronics', 'desc'=>'Premium branded tech accessories, gadgets, and electronics that keep your brand top of mind.'],
        ['icon'=>'M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01', 'title'=>'Clothing & Apparel', 'desc'=>'Team uniforms, event wear, and corporate apparel with precision embroidery and screen print.'],
        ['icon'=>'M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z', 'title'=>'Eco & Sustainable', 'desc'=>'Environmentally responsible products made from recycled and sustainable materials.'],
        ['icon'=>'M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4', 'title'=>'Bulk & Event Supply', 'desc'=>'Large-quantity event merchandise, trade show materials, and conference gift sets delivered on time.'],
      ];
      foreach ($services as $svc): ?>
      <div class="glass-card p-7">
        <div class="service-icon mb-5">
          <svg class="w-6 h-6" style="color:#C42830;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="<?= $svc['icon'] ?>"/>
          </svg>
        </div>
        <h3 style="color:#0E0B16;" class="font-semibold text-base mb-2"><?= $svc['title'] ?></h3>
        <p style="color:#7A7788;" class="text-sm leading-relaxed"><?= $svc['desc'] ?></p>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     PRODUCT CATEGORIES BENTO
════════════════════════════════════════════ -->
<section class="section-spacing" style="background:#EDEAE3;">
  <div class="container-xl">
    <div class="text-center mb-12 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>Categories</div>
      <h2 class="text-4xl md:text-5xl font-display font-bold mb-4" style="color:#0E0B16;">
        Explore <span class="gradient-text">6,000+</span> Products
      </h2>
      <p style="color:#7A7788;" class="max-w-lg mx-auto">Spanning eight major categories to cover every brand touchpoint.</p>
    </div>

    <div class="bento-grid">
      <?php
      $bento_items = [
        ['title'=>'Corporate Gifts',  'count'=>'450+','icon'=>'M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z','from'=>'#C42830','to'=>'#7C0C14','class'=>'bento-1','cat'=>'Corporate Gifts'],
        ['title'=>'Clothing',         'count'=>'320+','icon'=>'M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01','from'=>'#1C2E70','to'=>'#0E1A45','class'=>'bento-2','cat'=>'Clothing'],
        ['title'=>'Electronics',      'count'=>'280+','icon'=>'M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z','from'=>'#2A4294','to'=>'#1C2E70','class'=>'bento-3','cat'=>'Electronics'],
        ['title'=>'Office Supplies',  'count'=>'360+','icon'=>'M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z','from'=>'#059669','to'=>'#064E3B','class'=>'bento-4','cat'=>'Office'],
        ['title'=>'Bags & Travel',    'count'=>'210+','icon'=>'M9 17a2 2 0 11-4 0 2 2 0 014 0zM19 17a2 2 0 11-4 0 2 2 0 014 0z M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1','from'=>'#B45309','to'=>'#78350F','class'=>'bento-5','cat'=>'Bags'],
        ['title'=>'Luxury Collection','count'=>'95+', 'icon'=>'M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z','from'=>'#BE185D','to'=>'#881337','class'=>'bento-6','cat'=>'Luxury'],
      ];
      foreach ($bento_items as $item): ?>
      <a href="<?= $base ?>/catalog.php?cat=<?= urlencode($item['cat']) ?>"
         class="bento-item <?= $item['class'] ?>"
         style="background:linear-gradient(135deg,<?= $item['from'] ?>,<?= $item['to'] ?>);">
        <div style="position:absolute;top:0;left:0;right:0;height:2px;background:rgba(255,255,255,.15);border-radius:var(--radius-lg) var(--radius-lg) 0 0;"></div>
        <div class="bento-content">
          <div style="width:46px;height:46px;border-radius:12px;background:rgba(255,255,255,.15);display:flex;align-items:center;justify-content:center;margin-bottom:14px;">
            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="<?= $item['icon'] ?>"/>
            </svg>
          </div>
          <h3 class="text-white font-bold text-lg md:text-xl leading-tight mb-1"><?= $item['title'] ?></h3>
          <p class="text-white/60 text-sm font-medium"><?= $item['count'] ?> products</p>
        </div>
        <div class="absolute top-4 right-4 opacity-0 group-hover:opacity-100 transition-opacity">
          <svg class="w-5 h-5 text-white/80" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
          </svg>
        </div>
      </a>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     FEATURED CATALOGUES
════════════════════════════════════════════ -->
<section class="section-spacing" style="background:#FFFFFF;">
  <div class="container-xl">
    <div class="flex flex-col md:flex-row md:items-end md:justify-between gap-6 mb-12 reveal">
      <div>
        <div class="section-badge mb-6"><span class="dot"></span>2026 Catalogues</div>
        <h2 class="text-4xl md:text-5xl font-display font-bold" style="color:#0E0B16;">
          Latest <span class="gradient-text">Collections</span>
        </h2>
      </div>
      <a href="<?= $base ?>/catalog.php" class="btn-ghost px-6 py-3 rounded-full text-sm flex-shrink-0" style="border-color:rgba(0,0,0,.15);">
        View All Catalogues
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
        </svg>
      </a>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-5 stagger-children">
      <?php foreach (array_slice($featured, 0, 4) as $cat): ?>
      <a href="<?= $base ?>/catalog-pdf-viewer.php?id=<?= $cat['id'] ?>" class="catalog-card group block">
        <div class="catalog-cover" style="background:linear-gradient(135deg,<?= $cat['gradient_from'] ?>,<?= $cat['gradient_to'] ?>);">
          <div class="catalog-cover-pattern"></div>
          <span class="catalog-cover-number"><?= str_pad($cat['id'],2,'0',STR_PAD_LEFT) ?></span>
          <div style="position:absolute;top:12px;left:12px;display:flex;align-items:center;gap:5px;background:rgba(0,0,0,.35);border-radius:100px;padding:4px 10px;backdrop-filter:blur(8px);">
            <svg class="w-3 h-3 text-white/80" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
            </svg>
            <span style="font-size:9px;font-weight:600;color:rgba(255,255,255,.75);">View PDF</span>
          </div>
          <div class="absolute bottom-3 left-3">
            <span class="text-xs font-semibold text-white/90 tracking-wider uppercase bg-black/30 rounded-full px-3 py-1"><?= $cat['year'] ?></span>
          </div>
        </div>
        <div class="p-5">
          <div class="flex flex-wrap gap-1.5 mb-3">
            <?php foreach (array_slice($cat['tags'],0,2) as $tag): ?>
            <span class="catalog-tag" style="color:<?= $cat['accent'] ?>;background:<?= $cat['accent'] ?>18;border-color:<?= $cat['accent'] ?>25;"><?= $tag ?></span>
            <?php endforeach; ?>
          </div>
          <h3 style="color:#0E0B16;" class="font-semibold text-base mb-1.5 group-hover:text-[#C42830] transition-colors"><?= $cat['title'] ?></h3>
          <p style="color:#7A7788;" class="text-xs leading-relaxed mb-4 line-clamp-2"><?= $cat['description'] ?></p>
          <div class="flex items-center justify-between">
            <span style="color:#ADAAB8;" class="text-xs"><?= number_format($cat['products_count']) ?>+ products</span>
            <span class="text-xs font-semibold flex items-center gap-1" style="color:#C42830;">
              View PDF
              <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
              </svg>
            </span>
          </div>
        </div>
      </a>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     HOW TO ORDER — PROCESS
════════════════════════════════════════════ -->
<section class="section-spacing" style="background:#F6F3EE;">
  <div class="container-xl">
    <div class="text-center mb-16 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>Simple Process</div>
      <h2 class="text-4xl md:text-5xl font-display font-bold mb-4" style="color:#0E0B16;">
        Order in <span class="gradient-text">4 Easy Steps</span>
      </h2>
      <p style="color:#7A7788;" class="max-w-lg mx-auto">From browsing to delivery — we make corporate gifting effortless.</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-4 gap-8 md:gap-4 relative">
      <!-- Connector line -->
      <div class="hidden md:block absolute top-8 left-[calc(12.5%+16px)] right-[calc(12.5%+16px)] h-px process-connector"
           style="background:linear-gradient(to right,rgba(196,40,48,.5),rgba(28,46,112,.4));opacity:.6;">
      </div>

      <?php
      $steps = [
        ['num'=>'01','title'=>'Browse & Choose','desc'=>'Explore our 6,000+ product catalogue and select the perfect items for your brand.','icon'=>'M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z'],
        ['num'=>'02','title'=>'Share Your Brief','desc'=>'Send us your logo, quantity, and branding requirements. We respond within 2 hours.','icon'=>'M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z'],
        ['num'=>'03','title'=>'Review & Approve','desc'=>'Get a digital proof within 24 hours. Approve your design and confirm the order.','icon'=>'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z'],
        ['num'=>'04','title'=>'Delivered to You','desc'=>'Your branded products arrive on time, perfectly packaged and ready to impress.','icon'=>'M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4'],
      ];
      foreach ($steps as $i => $step): ?>
      <div class="process-step text-center reveal" style="transition-delay:<?= $i*.12 ?>s">
        <div class="process-number mb-6 mx-auto"><?= $step['num'] ?></div>
        <div class="service-icon mx-auto mb-4">
          <svg class="w-5 h-5" style="color:#C42830;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="<?= $step['icon'] ?>"/>
          </svg>
        </div>
        <h3 style="color:#0E0B16;" class="font-semibold text-base mb-2"><?= $step['title'] ?></h3>
        <p style="color:#7A7788;" class="text-sm leading-relaxed max-w-[200px] mx-auto"><?= $step['desc'] ?></p>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     WHY RAMBLER
════════════════════════════════════════════ -->
<section id="about" class="section-spacing" style="background:#FFFFFF;">
  <div class="container-xl">
    <div class="text-center mb-14 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>Why Choose Us</div>
      <h2 class="text-4xl md:text-5xl font-display font-bold mb-4" style="color:#0E0B16;">
        The Rambler <span class="gradient-text">Difference</span>
      </h2>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
      <?php
      $whys = [
        ['num'=>'10','title'=>'Years of Excellence','desc'=>'A decade of delivering premium branded merchandise across the Middle East, Europe, and Asia. Our experience shows in every detail.','col'=>'#C42830'],
        ['num'=>'24h','title'=>'Quote Turnaround','desc'=>'From enquiry to quote in under 24 hours. We respect your time and move fast without compromising on quality or accuracy.','col'=>'#1C2E70'],
        ['num'=>'∞','title'=>'Customisation Options','desc'=>'Every product is customisable — colour, size, material, finish, and branding method. If you can imagine it, we can make it.','col'=>'#059669'],
      ];
      foreach ($whys as $w): ?>
      <div class="why-card">
        <div class="display-number mb-4" style="-webkit-text-fill-color:transparent;background:linear-gradient(135deg,<?= $w['col'] ?>40,<?= $w['col'] ?>12);-webkit-background-clip:text;background-clip:text;">
          <?= $w['num'] ?>
        </div>
        <div style="width:40px;height:40px;border-radius:12px;margin-bottom:20px;display:flex;align-items:center;justify-content:center;background:<?= $w['col'] ?>15;">
          <span style="width:10px;height:10px;border-radius:50%;background:<?= $w['col'] ?>;"></span>
        </div>
        <h3 style="color:#0E0B16;" class="font-bold text-xl mb-3"><?= $w['title'] ?></h3>
        <p style="color:#7A7788;" class="text-sm leading-relaxed"><?= $w['desc'] ?></p>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     CLIENT MARQUEE
════════════════════════════════════════════ -->
<section class="py-16 overflow-hidden" style="background:#EDEAE3;border-top:1px solid rgba(0,0,0,.06);border-bottom:1px solid rgba(0,0,0,.06);">
  <div class="text-center mb-10 reveal">
    <p style="font-size:11px;color:#ADAAB8;letter-spacing:.2em;text-transform:uppercase;font-weight:600;">Trusted by Leading Brands Across Qatar & Beyond</p>
  </div>
  <div class="marquee-wrapper">
    <div class="marquee-track">
      <?php
      $clients = ['Qatar Airways','Ooredoo','QNB Group','Hamad Medical','RasGas','Qatar Steel','Commercial Bank','Milaha','Barwa','Woqod','Al Jazeera','Nakilat','Qatar Foundation','Qatargas','Vodafone Qatar','Qatar Airways','Ooredoo','QNB Group','Hamad Medical','RasGas','Qatar Steel','Commercial Bank','Milaha','Barwa','Woqod','Al Jazeera','Nakilat','Qatar Foundation','Qatargas','Vodafone Qatar'];
      foreach ($clients as $c): ?>
      <span class="marquee-item"><?= $c ?></span>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     TESTIMONIALS
════════════════════════════════════════════ -->
<section class="section-spacing" style="background:#F6F3EE;">
  <div class="container-xl">
    <div class="text-center mb-14 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>Client Stories</div>
      <h2 class="text-4xl md:text-5xl font-display font-bold mb-4" style="color:#0E0B16;">
        What Our Clients <span class="gradient-text">Say</span>
      </h2>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 stagger-children">
      <?php
      $testimonials = [
        ['quote'=>'Rambler delivered 1,500 custom gifts for our annual gala in just 10 days. The quality was exceptional and every client was impressed. Will definitely use again.','name'=>'Sarah Al-Mansouri','role'=>'Head of Marketing, QNB Group','stars'=>5],
        ['quote'=>'The attention to detail and branding quality is unlike any other supplier we\'ve worked with in Qatar. Their team understood our brand guidelines perfectly.','name'=>'James Mitchell','role'=>'Brand Manager, Ooredoo Qatar','stars'=>5],
        ['quote'=>'From the first email to final delivery, the experience was seamless. Competitive pricing, premium quality, and an outstanding team. Highly recommended.','name'=>'Aisha Al-Thani','role'=>'Events Director, Qatar Foundation','stars'=>5],
      ];
      foreach ($testimonials as $t): ?>
      <div class="testimonial-card">
        <div class="testimonial-quote">"</div>
        <div class="star-rating mb-4">
          <?= str_repeat('<svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/></svg>',$t['stars']) ?>
        </div>
        <p style="color:#5A5766;" class="text-sm leading-relaxed mb-6 italic">"<?= $t['quote'] ?>"</p>
        <div class="flex items-center gap-3">
          <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold text-white"
               style="background:linear-gradient(135deg,#C42830,#A81F26);">
            <?= strtoupper(substr($t['name'],0,1)) ?>
          </div>
          <div>
            <div style="color:#0E0B16;" class="text-sm font-semibold"><?= $t['name'] ?></div>
            <div style="color:#ADAAB8;" class="text-xs"><?= $t['role'] ?></div>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     CTA BANNER — Dark Navy for premium contrast
════════════════════════════════════════════ -->
<section class="cta-section section-spacing">
  <div class="cta-bg"></div>
  <!-- Extra depth orbs for luxury drama -->
  <div class="cta-orb cta-orb-1"></div>
  <div class="cta-orb cta-orb-2"></div>
  <div class="cta-orb cta-orb-3"></div>
  <div class="container-xl relative z-10 text-center reveal">
    <div class="section-badge mx-auto mb-8" style="background:rgba(255,255,255,.08);border-color:rgba(255,255,255,.15);color:rgba(255,255,255,.8);">
      <span class="dot" style="background:#E03540;"></span>Ready to Start?
    </div>
    <h2 class="text-4xl md:text-6xl font-display font-bold text-white mb-6 leading-tight">
      Your Brand Deserves<br>
      <span style="background:linear-gradient(135deg,#FF6B7A,#E03540,#6B8EFF);-webkit-background-clip:text;-webkit-text-fill-color:transparent;background-clip:text;">Premium Gifting</span>
    </h2>
    <p class="text-white/60 text-base md:text-lg max-w-xl mx-auto mb-10">
      Get a free, no-obligation quote within 24 hours. Our team is ready to bring your vision to life.
    </p>
    <div class="flex flex-wrap gap-4 justify-center">
      <a href="#contact" class="btn-primary px-8 py-4 rounded-full text-sm font-semibold">
        Request a Free Quote
        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
        </svg>
      </a>
      <a href="<?= $base ?>/catalog.php" class="px-8 py-4 rounded-full text-sm font-semibold border border-white/25 text-white/80 hover:bg-white/10 hover:border-white/40 transition-all inline-flex items-center gap-2">
        Browse Catalogue
      </a>
    </div>
    <div class="flex flex-wrap items-center justify-center gap-8 mt-12 pt-12" style="border-top:1px solid rgba(255,255,255,.1);">
      <?php foreach (['✓ No minimum order','✓ Free design proof','✓ 24h response','✓ Qatar-wide delivery'] as $q): ?>
      <span class="text-sm text-white/45 font-medium"><?= $q ?></span>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     CONTACT SECTION
════════════════════════════════════════════ -->
<section id="contact" class="section-spacing" style="background:#FFFFFF;">
  <div class="container-xl">
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-start">

      <!-- Left: Info -->
      <div class="reveal-left">
        <div class="section-badge mb-8"><span class="dot"></span>Get In Touch</div>
        <h2 class="text-4xl md:text-5xl font-display font-bold mb-6" style="color:#0E0B16;">
          Let's Build Something<br>
          <span class="gradient-text">Extraordinary</span>
        </h2>
        <p style="color:#7A7788;" class="text-base leading-relaxed mb-10">
          Have a project in mind? Tell us about your brand, and our team will respond with a tailored proposal within 24 hours.
        </p>

        <div class="space-y-4">
          <?php
          $contacts = [
            ['icon'=>'M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z','label'=>'Phone','val'=>'+974 7099 3232','href'=>'tel:+97470993232'],
            ['icon'=>'M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z','label'=>'Email','val'=>'sales@ramblerco.com','href'=>'mailto:sales@ramblerco.com'],
            ['icon'=>'M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z M15 11a3 3 0 11-6 0 3 3 0 016 0z','label'=>'Address','val'=>'P.O. BOX 8898, Doha, Qatar','href'=>'#'],
          ];
          foreach ($contacts as $c): ?>
          <div class="contact-info-card">
            <div class="contact-icon">
              <svg class="w-5 h-5" style="color:#C42830;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="<?= $c['icon'] ?>"/>
              </svg>
            </div>
            <div>
              <span style="color:#ADAAB8;" class="block text-xs mb-0.5 font-semibold tracking-wide uppercase"><?= $c['label'] ?></span>
              <a href="<?= $c['href'] ?>" style="color:#3A3745;" class="text-sm hover:text-[#C42830] transition-colors"><?= $c['val'] ?></a>
            </div>
          </div>
          <?php endforeach; ?>
        </div>
      </div>

      <!-- Right: Form -->
      <div class="reveal-right">
        <div class="glass-card p-8 md:p-10" style="background:#F6F3EE;border-color:rgba(0,0,0,.08);">
          <h3 style="color:#0E0B16;" class="font-bold text-xl mb-8">Send Us a Message</h3>
          <form id="contact-form" class="space-y-5">
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-5">
              <div>
                <label class="form-label">Full Name</label>
                <input type="text" class="form-field" placeholder="John Smith" required>
              </div>
              <div>
                <label class="form-label">Company</label>
                <input type="text" class="form-field" placeholder="Your Company">
              </div>
            </div>
            <div>
              <label class="form-label">Email Address</label>
              <input type="email" class="form-field" placeholder="john@company.com" required>
            </div>
            <div>
              <label class="form-label">Phone Number</label>
              <input type="tel" class="form-field" placeholder="+974 XXXX XXXX">
            </div>
            <div>
              <label class="form-label">Product / Service Needed</label>
              <select class="form-field">
                <option value="">Select a category</option>
                <?php foreach ($catalogs as $cat): ?>
                <option value="<?= $cat['category'] ?>"><?= $cat['title'] ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div>
              <label class="form-label">Message</label>
              <textarea class="form-field" rows="4" placeholder="Tell us about your project, quantity needed, and timeline..."></textarea>
            </div>
            <button type="submit" class="btn-primary w-full py-4 rounded-xl text-sm font-semibold justify-center">
              Send Message
              <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
              </svg>
            </button>
            <p style="color:#ADAAB8;" class="text-center text-xs">We'll respond within 24 hours. No spam, ever.</p>
          </form>
        </div>
      </div>

    </div>
  </div>
</section>

<?php include __DIR__ . '/includes/footer.php'; ?>
